<?php
/**
 * FieldTypeDefinition
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Automation Actions V4
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v4
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Automation\Actions\Model;

use \ArrayAccess;
use \HubSpot\Client\Automation\Actions\ObjectSerializer;

/**
 * FieldTypeDefinition Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldTypeDefinition implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FieldTypeDefinition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'help_text' => 'string',
        'referenced_object_type' => 'string',
        'name' => 'string',
        'options' => '\HubSpot\Client\Automation\Actions\Model\Option[]',
        'description' => 'string',
        'external_options_reference_type' => 'string',
        'label' => 'string',
        'type' => 'string',
        'field_type' => 'string',
        'options_url' => 'string',
        'external_options' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'help_text' => null,
        'referenced_object_type' => null,
        'name' => null,
        'options' => null,
        'description' => null,
        'external_options_reference_type' => null,
        'label' => null,
        'type' => null,
        'field_type' => null,
        'options_url' => null,
        'external_options' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'help_text' => false,
        'referenced_object_type' => false,
        'name' => false,
        'options' => false,
        'description' => false,
        'external_options_reference_type' => false,
        'label' => false,
        'type' => false,
        'field_type' => false,
        'options_url' => false,
        'external_options' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'help_text' => 'helpText',
        'referenced_object_type' => 'referencedObjectType',
        'name' => 'name',
        'options' => 'options',
        'description' => 'description',
        'external_options_reference_type' => 'externalOptionsReferenceType',
        'label' => 'label',
        'type' => 'type',
        'field_type' => 'fieldType',
        'options_url' => 'optionsUrl',
        'external_options' => 'externalOptions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'help_text' => 'setHelpText',
        'referenced_object_type' => 'setReferencedObjectType',
        'name' => 'setName',
        'options' => 'setOptions',
        'description' => 'setDescription',
        'external_options_reference_type' => 'setExternalOptionsReferenceType',
        'label' => 'setLabel',
        'type' => 'setType',
        'field_type' => 'setFieldType',
        'options_url' => 'setOptionsUrl',
        'external_options' => 'setExternalOptions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'help_text' => 'getHelpText',
        'referenced_object_type' => 'getReferencedObjectType',
        'name' => 'getName',
        'options' => 'getOptions',
        'description' => 'getDescription',
        'external_options_reference_type' => 'getExternalOptionsReferenceType',
        'label' => 'getLabel',
        'type' => 'getType',
        'field_type' => 'getFieldType',
        'options_url' => 'getOptionsUrl',
        'external_options' => 'getExternalOptions'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const REFERENCED_OBJECT_TYPE_CONTACT = 'CONTACT';
    public const REFERENCED_OBJECT_TYPE_COMPANY = 'COMPANY';
    public const REFERENCED_OBJECT_TYPE_DEAL = 'DEAL';
    public const REFERENCED_OBJECT_TYPE_ENGAGEMENT = 'ENGAGEMENT';
    public const REFERENCED_OBJECT_TYPE_TICKET = 'TICKET';
    public const REFERENCED_OBJECT_TYPE_OWNER = 'OWNER';
    public const REFERENCED_OBJECT_TYPE_PRODUCT = 'PRODUCT';
    public const REFERENCED_OBJECT_TYPE_LINE_ITEM = 'LINE_ITEM';
    public const REFERENCED_OBJECT_TYPE_BET_DELIVERABLE_SERVICE = 'BET_DELIVERABLE_SERVICE';
    public const REFERENCED_OBJECT_TYPE_CONTENT = 'CONTENT';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION = 'CONVERSATION';
    public const REFERENCED_OBJECT_TYPE_BET_ALERT = 'BET_ALERT';
    public const REFERENCED_OBJECT_TYPE_PORTAL = 'PORTAL';
    public const REFERENCED_OBJECT_TYPE_QUOTE = 'QUOTE';
    public const REFERENCED_OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB = 'FORM_SUBMISSION_INBOUNDDB';
    public const REFERENCED_OBJECT_TYPE_QUOTA = 'QUOTA';
    public const REFERENCED_OBJECT_TYPE_UNSUBSCRIBE = 'UNSUBSCRIBE';
    public const REFERENCED_OBJECT_TYPE_COMMUNICATION = 'COMMUNICATION';
    public const REFERENCED_OBJECT_TYPE_FEEDBACK_SUBMISSION = 'FEEDBACK_SUBMISSION';
    public const REFERENCED_OBJECT_TYPE_ATTRIBUTION = 'ATTRIBUTION';
    public const REFERENCED_OBJECT_TYPE_SALESFORCE_SYNC_ERROR = 'SALESFORCE_SYNC_ERROR';
    public const REFERENCED_OBJECT_TYPE_RESTORABLE_CRM_OBJECT = 'RESTORABLE_CRM_OBJECT';
    public const REFERENCED_OBJECT_TYPE_HUB = 'HUB';
    public const REFERENCED_OBJECT_TYPE_LANDING_PAGE = 'LANDING_PAGE';
    public const REFERENCED_OBJECT_TYPE_PRODUCT_OR_FOLDER = 'PRODUCT_OR_FOLDER';
    public const REFERENCED_OBJECT_TYPE_TASK = 'TASK';
    public const REFERENCED_OBJECT_TYPE_FORM = 'FORM';
    public const REFERENCED_OBJECT_TYPE_MARKETING_EMAIL = 'MARKETING_EMAIL';
    public const REFERENCED_OBJECT_TYPE_AD_ACCOUNT = 'AD_ACCOUNT';
    public const REFERENCED_OBJECT_TYPE_AD_CAMPAIGN = 'AD_CAMPAIGN';
    public const REFERENCED_OBJECT_TYPE_AD_GROUP = 'AD_GROUP';
    public const REFERENCED_OBJECT_TYPE_AD = 'AD';
    public const REFERENCED_OBJECT_TYPE_KEYWORD = 'KEYWORD';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN = 'CAMPAIGN';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_CHANNEL = 'SOCIAL_CHANNEL';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_POST = 'SOCIAL_POST';
    public const REFERENCED_OBJECT_TYPE_SITE_PAGE = 'SITE_PAGE';
    public const REFERENCED_OBJECT_TYPE_BLOG_POST = 'BLOG_POST';
    public const REFERENCED_OBJECT_TYPE_IMPORT = 'IMPORT';
    public const REFERENCED_OBJECT_TYPE_EXPORT = 'EXPORT';
    public const REFERENCED_OBJECT_TYPE_CTA = 'CTA';
    public const REFERENCED_OBJECT_TYPE_TASK_TEMPLATE = 'TASK_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW = 'AUTOMATION_PLATFORM_FLOW';
    public const REFERENCED_OBJECT_TYPE_OBJECT_LIST = 'OBJECT_LIST';
    public const REFERENCED_OBJECT_TYPE_NOTE = 'NOTE';
    public const REFERENCED_OBJECT_TYPE_MEETING_EVENT = 'MEETING_EVENT';
    public const REFERENCED_OBJECT_TYPE_CALL = 'CALL';
    public const REFERENCED_OBJECT_TYPE_EMAIL = 'EMAIL';
    public const REFERENCED_OBJECT_TYPE_PUBLISHING_TASK = 'PUBLISHING_TASK';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION_SESSION = 'CONVERSATION_SESSION';
    public const REFERENCED_OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION = 'CONTACT_CREATE_ATTRIBUTION';
    public const REFERENCED_OBJECT_TYPE_INVOICE = 'INVOICE';
    public const REFERENCED_OBJECT_TYPE_MARKETING_EVENT = 'MARKETING_EVENT';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION_INBOX = 'CONVERSATION_INBOX';
    public const REFERENCED_OBJECT_TYPE_CHATFLOW = 'CHATFLOW';
    public const REFERENCED_OBJECT_TYPE_MEDIA_BRIDGE = 'MEDIA_BRIDGE';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE = 'SEQUENCE';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE_STEP = 'SEQUENCE_STEP';
    public const REFERENCED_OBJECT_TYPE_FORECAST = 'FORECAST';
    public const REFERENCED_OBJECT_TYPE_SNIPPET = 'SNIPPET';
    public const REFERENCED_OBJECT_TYPE_TEMPLATE = 'TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_DEAL_CREATE_ATTRIBUTION = 'DEAL_CREATE_ATTRIBUTION';
    public const REFERENCED_OBJECT_TYPE_QUOTE_TEMPLATE = 'QUOTE_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_QUOTE_MODULE = 'QUOTE_MODULE';
    public const REFERENCED_OBJECT_TYPE_QUOTE_MODULE_FIELD = 'QUOTE_MODULE_FIELD';
    public const REFERENCED_OBJECT_TYPE_QUOTE_FIELD = 'QUOTE_FIELD';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE_ENROLLMENT = 'SEQUENCE_ENROLLMENT';
    public const REFERENCED_OBJECT_TYPE_SUBSCRIPTION = 'SUBSCRIPTION';
    public const REFERENCED_OBJECT_TYPE_ACCEPTANCE_TEST = 'ACCEPTANCE_TEST';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_BROADCAST = 'SOCIAL_BROADCAST';
    public const REFERENCED_OBJECT_TYPE_DEAL_SPLIT = 'DEAL_SPLIT';
    public const REFERENCED_OBJECT_TYPE_DEAL_REGISTRATION = 'DEAL_REGISTRATION';
    public const REFERENCED_OBJECT_TYPE_GOAL_TARGET = 'GOAL_TARGET';
    public const REFERENCED_OBJECT_TYPE_GOAL_TARGET_GROUP = 'GOAL_TARGET_GROUP';
    public const REFERENCED_OBJECT_TYPE_PORTAL_OBJECT_SYNC_MESSAGE = 'PORTAL_OBJECT_SYNC_MESSAGE';
    public const REFERENCED_OBJECT_TYPE_FILE_MANAGER_FILE = 'FILE_MANAGER_FILE';
    public const REFERENCED_OBJECT_TYPE_FILE_MANAGER_FOLDER = 'FILE_MANAGER_FOLDER';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE_STEP_ENROLLMENT = 'SEQUENCE_STEP_ENROLLMENT';
    public const REFERENCED_OBJECT_TYPE_APPROVAL = 'APPROVAL';
    public const REFERENCED_OBJECT_TYPE_APPROVAL_STEP = 'APPROVAL_STEP';
    public const REFERENCED_OBJECT_TYPE_CTA_VARIANT = 'CTA_VARIANT';
    public const REFERENCED_OBJECT_TYPE_SALES_DOCUMENT = 'SALES_DOCUMENT';
    public const REFERENCED_OBJECT_TYPE_DISCOUNT = 'DISCOUNT';
    public const REFERENCED_OBJECT_TYPE_FEE = 'FEE';
    public const REFERENCED_OBJECT_TYPE_TAX = 'TAX';
    public const REFERENCED_OBJECT_TYPE_MARKETING_CALENDAR = 'MARKETING_CALENDAR';
    public const REFERENCED_OBJECT_TYPE_PERMISSIONS_TESTING = 'PERMISSIONS_TESTING';
    public const REFERENCED_OBJECT_TYPE_PRIVACY_SCANNER_COOKIE = 'PRIVACY_SCANNER_COOKIE';
    public const REFERENCED_OBJECT_TYPE_DATA_SYNC_STATE = 'DATA_SYNC_STATE';
    public const REFERENCED_OBJECT_TYPE_WEB_INTERACTIVE = 'WEB_INTERACTIVE';
    public const REFERENCED_OBJECT_TYPE_PLAYBOOK = 'PLAYBOOK';
    public const REFERENCED_OBJECT_TYPE_FOLDER = 'FOLDER';
    public const REFERENCED_OBJECT_TYPE_PLAYBOOK_QUESTION = 'PLAYBOOK_QUESTION';
    public const REFERENCED_OBJECT_TYPE_PLAYBOOK_SUBMISSION = 'PLAYBOOK_SUBMISSION';
    public const REFERENCED_OBJECT_TYPE_PLAYBOOK_SUBMISSION_ANSWER = 'PLAYBOOK_SUBMISSION_ANSWER';
    public const REFERENCED_OBJECT_TYPE_COMMERCE_PAYMENT = 'COMMERCE_PAYMENT';
    public const REFERENCED_OBJECT_TYPE_GSC_PROPERTY = 'GSC_PROPERTY';
    public const REFERENCED_OBJECT_TYPE_SOX_PROTECTED_DUMMY_TYPE = 'SOX_PROTECTED_DUMMY_TYPE';
    public const REFERENCED_OBJECT_TYPE_BLOG_LISTING_PAGE = 'BLOG_LISTING_PAGE';
    public const REFERENCED_OBJECT_TYPE_QUARANTINED_SUBMISSION = 'QUARANTINED_SUBMISSION';
    public const REFERENCED_OBJECT_TYPE_PAYMENT_SCHEDULE = 'PAYMENT_SCHEDULE';
    public const REFERENCED_OBJECT_TYPE_PAYMENT_SCHEDULE_INSTALLMENT = 'PAYMENT_SCHEDULE_INSTALLMENT';
    public const REFERENCED_OBJECT_TYPE_MARKETING_CAMPAIGN_UTM = 'MARKETING_CAMPAIGN_UTM';
    public const REFERENCED_OBJECT_TYPE_DISCOUNT_TEMPLATE = 'DISCOUNT_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_DISCOUNT_CODE = 'DISCOUNT_CODE';
    public const REFERENCED_OBJECT_TYPE_FEEDBACK_SURVEY = 'FEEDBACK_SURVEY';
    public const REFERENCED_OBJECT_TYPE_CMS_URL = 'CMS_URL';
    public const REFERENCED_OBJECT_TYPE_SALES_TASK = 'SALES_TASK';
    public const REFERENCED_OBJECT_TYPE_SALES_WORKLOAD = 'SALES_WORKLOAD';
    public const REFERENCED_OBJECT_TYPE_USER = 'USER';
    public const REFERENCED_OBJECT_TYPE_POSTAL_MAIL = 'POSTAL_MAIL';
    public const REFERENCED_OBJECT_TYPE_SCHEMAS_BACKEND_TEST = 'SCHEMAS_BACKEND_TEST';
    public const REFERENCED_OBJECT_TYPE_PAYMENT_LINK = 'PAYMENT_LINK';
    public const REFERENCED_OBJECT_TYPE_SUBMISSION_TAG = 'SUBMISSION_TAG';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN_STEP = 'CAMPAIGN_STEP';
    public const REFERENCED_OBJECT_TYPE_SCHEDULING_PAGE = 'SCHEDULING_PAGE';
    public const REFERENCED_OBJECT_TYPE_SOX_PROTECTED_TEST_TYPE = 'SOX_PROTECTED_TEST_TYPE';
    public const REFERENCED_OBJECT_TYPE_ORDER = 'ORDER';
    public const REFERENCED_OBJECT_TYPE_MARKETING_SMS = 'MARKETING_SMS';
    public const REFERENCED_OBJECT_TYPE_PARTNER_ACCOUNT = 'PARTNER_ACCOUNT';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN_TEMPLATE = 'CAMPAIGN_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN_TEMPLATE_STEP = 'CAMPAIGN_TEMPLATE_STEP';
    public const REFERENCED_OBJECT_TYPE_PLAYLIST = 'PLAYLIST';
    public const REFERENCED_OBJECT_TYPE_CLIP = 'CLIP';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN_BUDGET_ITEM = 'CAMPAIGN_BUDGET_ITEM';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN_SPEND_ITEM = 'CAMPAIGN_SPEND_ITEM';
    public const REFERENCED_OBJECT_TYPE_MIC = 'MIC';
    public const REFERENCED_OBJECT_TYPE_CONTENT_AUDIT = 'CONTENT_AUDIT';
    public const REFERENCED_OBJECT_TYPE_CONTENT_AUDIT_PAGE = 'CONTENT_AUDIT_PAGE';
    public const REFERENCED_OBJECT_TYPE_PLAYLIST_FOLDER = 'PLAYLIST_FOLDER';
    public const REFERENCED_OBJECT_TYPE_LEAD = 'LEAD';
    public const REFERENCED_OBJECT_TYPE_ABANDONED_CART = 'ABANDONED_CART';
    public const REFERENCED_OBJECT_TYPE_EXTERNAL_WEB_URL = 'EXTERNAL_WEB_URL';
    public const REFERENCED_OBJECT_TYPE_VIEW = 'VIEW';
    public const REFERENCED_OBJECT_TYPE_VIEW_BLOCK = 'VIEW_BLOCK';
    public const REFERENCED_OBJECT_TYPE_ROSTER = 'ROSTER';
    public const REFERENCED_OBJECT_TYPE_CART = 'CART';
    public const REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW_ACTION = 'AUTOMATION_PLATFORM_FLOW_ACTION';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_PROFILE = 'SOCIAL_PROFILE';
    public const REFERENCED_OBJECT_TYPE_PARTNER_CLIENT = 'PARTNER_CLIENT';
    public const REFERENCED_OBJECT_TYPE_ROSTER_MEMBER = 'ROSTER_MEMBER';
    public const REFERENCED_OBJECT_TYPE_MARKETING_EVENT_ATTENDANCE = 'MARKETING_EVENT_ATTENDANCE';
    public const REFERENCED_OBJECT_TYPE_ALL_PAGES = 'ALL_PAGES';
    public const REFERENCED_OBJECT_TYPE_AI_FORECAST = 'AI_FORECAST';
    public const REFERENCED_OBJECT_TYPE_CRM_PIPELINES_DUMMY_TYPE = 'CRM_PIPELINES_DUMMY_TYPE';
    public const REFERENCED_OBJECT_TYPE_KNOWLEDGE_ARTICLE = 'KNOWLEDGE_ARTICLE';
    public const REFERENCED_OBJECT_TYPE_PROPERTY_INFO = 'PROPERTY_INFO';
    public const REFERENCED_OBJECT_TYPE_DATA_PRIVACY_CONSENT = 'DATA_PRIVACY_CONSENT';
    public const REFERENCED_OBJECT_TYPE_GOAL_TEMPLATE = 'GOAL_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_SCORE_CONFIGURATION = 'SCORE_CONFIGURATION';
    public const REFERENCED_OBJECT_TYPE_AUDIENCE = 'AUDIENCE';
    public const REFERENCED_OBJECT_TYPE_PARTNER_CLIENT_REVENUE = 'PARTNER_CLIENT_REVENUE';
    public const REFERENCED_OBJECT_TYPE_AUTOMATION_JOURNEY = 'AUTOMATION_JOURNEY';
    public const REFERENCED_OBJECT_TYPE_UNKNOWN = 'UNKNOWN';
    public const TYPE_STRING = 'string';
    public const TYPE_NUMBER = 'number';
    public const TYPE_BOOL = 'bool';
    public const TYPE_DATETIME = 'datetime';
    public const TYPE_ENUMERATION = 'enumeration';
    public const TYPE_DATE = 'date';
    public const TYPE_PHONE_NUMBER = 'phone_number';
    public const TYPE_CURRENCY_NUMBER = 'currency_number';
    public const TYPE_JSON = 'json';
    public const TYPE_OBJECT_COORDINATES = 'object_coordinates';
    public const FIELD_TYPE_BOOLEANCHECKBOX = 'booleancheckbox';
    public const FIELD_TYPE_CHECKBOX = 'checkbox';
    public const FIELD_TYPE_DATE = 'date';
    public const FIELD_TYPE_FILE = 'file';
    public const FIELD_TYPE_NUMBER = 'number';
    public const FIELD_TYPE_PHONENUMBER = 'phonenumber';
    public const FIELD_TYPE_RADIO = 'radio';
    public const FIELD_TYPE_SELECT = 'select';
    public const FIELD_TYPE_TEXT = 'text';
    public const FIELD_TYPE_TEXTAREA = 'textarea';
    public const FIELD_TYPE_CALCULATION_EQUATION = 'calculation_equation';
    public const FIELD_TYPE_CALCULATION_ROLLUP = 'calculation_rollup';
    public const FIELD_TYPE_CALCULATION_SCORE = 'calculation_score';
    public const FIELD_TYPE_CALCULATION_READ_TIME = 'calculation_read_time';
    public const FIELD_TYPE_UNKNOWN = 'unknown';
    public const FIELD_TYPE_HTML = 'html';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getReferencedObjectTypeAllowableValues()
    {
        return [
            self::REFERENCED_OBJECT_TYPE_CONTACT,
            self::REFERENCED_OBJECT_TYPE_COMPANY,
            self::REFERENCED_OBJECT_TYPE_DEAL,
            self::REFERENCED_OBJECT_TYPE_ENGAGEMENT,
            self::REFERENCED_OBJECT_TYPE_TICKET,
            self::REFERENCED_OBJECT_TYPE_OWNER,
            self::REFERENCED_OBJECT_TYPE_PRODUCT,
            self::REFERENCED_OBJECT_TYPE_LINE_ITEM,
            self::REFERENCED_OBJECT_TYPE_BET_DELIVERABLE_SERVICE,
            self::REFERENCED_OBJECT_TYPE_CONTENT,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION,
            self::REFERENCED_OBJECT_TYPE_BET_ALERT,
            self::REFERENCED_OBJECT_TYPE_PORTAL,
            self::REFERENCED_OBJECT_TYPE_QUOTE,
            self::REFERENCED_OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB,
            self::REFERENCED_OBJECT_TYPE_QUOTA,
            self::REFERENCED_OBJECT_TYPE_UNSUBSCRIBE,
            self::REFERENCED_OBJECT_TYPE_COMMUNICATION,
            self::REFERENCED_OBJECT_TYPE_FEEDBACK_SUBMISSION,
            self::REFERENCED_OBJECT_TYPE_ATTRIBUTION,
            self::REFERENCED_OBJECT_TYPE_SALESFORCE_SYNC_ERROR,
            self::REFERENCED_OBJECT_TYPE_RESTORABLE_CRM_OBJECT,
            self::REFERENCED_OBJECT_TYPE_HUB,
            self::REFERENCED_OBJECT_TYPE_LANDING_PAGE,
            self::REFERENCED_OBJECT_TYPE_PRODUCT_OR_FOLDER,
            self::REFERENCED_OBJECT_TYPE_TASK,
            self::REFERENCED_OBJECT_TYPE_FORM,
            self::REFERENCED_OBJECT_TYPE_MARKETING_EMAIL,
            self::REFERENCED_OBJECT_TYPE_AD_ACCOUNT,
            self::REFERENCED_OBJECT_TYPE_AD_CAMPAIGN,
            self::REFERENCED_OBJECT_TYPE_AD_GROUP,
            self::REFERENCED_OBJECT_TYPE_AD,
            self::REFERENCED_OBJECT_TYPE_KEYWORD,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_CHANNEL,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_POST,
            self::REFERENCED_OBJECT_TYPE_SITE_PAGE,
            self::REFERENCED_OBJECT_TYPE_BLOG_POST,
            self::REFERENCED_OBJECT_TYPE_IMPORT,
            self::REFERENCED_OBJECT_TYPE_EXPORT,
            self::REFERENCED_OBJECT_TYPE_CTA,
            self::REFERENCED_OBJECT_TYPE_TASK_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW,
            self::REFERENCED_OBJECT_TYPE_OBJECT_LIST,
            self::REFERENCED_OBJECT_TYPE_NOTE,
            self::REFERENCED_OBJECT_TYPE_MEETING_EVENT,
            self::REFERENCED_OBJECT_TYPE_CALL,
            self::REFERENCED_OBJECT_TYPE_EMAIL,
            self::REFERENCED_OBJECT_TYPE_PUBLISHING_TASK,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION_SESSION,
            self::REFERENCED_OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION,
            self::REFERENCED_OBJECT_TYPE_INVOICE,
            self::REFERENCED_OBJECT_TYPE_MARKETING_EVENT,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION_INBOX,
            self::REFERENCED_OBJECT_TYPE_CHATFLOW,
            self::REFERENCED_OBJECT_TYPE_MEDIA_BRIDGE,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE_STEP,
            self::REFERENCED_OBJECT_TYPE_FORECAST,
            self::REFERENCED_OBJECT_TYPE_SNIPPET,
            self::REFERENCED_OBJECT_TYPE_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_DEAL_CREATE_ATTRIBUTION,
            self::REFERENCED_OBJECT_TYPE_QUOTE_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_QUOTE_MODULE,
            self::REFERENCED_OBJECT_TYPE_QUOTE_MODULE_FIELD,
            self::REFERENCED_OBJECT_TYPE_QUOTE_FIELD,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE_ENROLLMENT,
            self::REFERENCED_OBJECT_TYPE_SUBSCRIPTION,
            self::REFERENCED_OBJECT_TYPE_ACCEPTANCE_TEST,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_BROADCAST,
            self::REFERENCED_OBJECT_TYPE_DEAL_SPLIT,
            self::REFERENCED_OBJECT_TYPE_DEAL_REGISTRATION,
            self::REFERENCED_OBJECT_TYPE_GOAL_TARGET,
            self::REFERENCED_OBJECT_TYPE_GOAL_TARGET_GROUP,
            self::REFERENCED_OBJECT_TYPE_PORTAL_OBJECT_SYNC_MESSAGE,
            self::REFERENCED_OBJECT_TYPE_FILE_MANAGER_FILE,
            self::REFERENCED_OBJECT_TYPE_FILE_MANAGER_FOLDER,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE_STEP_ENROLLMENT,
            self::REFERENCED_OBJECT_TYPE_APPROVAL,
            self::REFERENCED_OBJECT_TYPE_APPROVAL_STEP,
            self::REFERENCED_OBJECT_TYPE_CTA_VARIANT,
            self::REFERENCED_OBJECT_TYPE_SALES_DOCUMENT,
            self::REFERENCED_OBJECT_TYPE_DISCOUNT,
            self::REFERENCED_OBJECT_TYPE_FEE,
            self::REFERENCED_OBJECT_TYPE_TAX,
            self::REFERENCED_OBJECT_TYPE_MARKETING_CALENDAR,
            self::REFERENCED_OBJECT_TYPE_PERMISSIONS_TESTING,
            self::REFERENCED_OBJECT_TYPE_PRIVACY_SCANNER_COOKIE,
            self::REFERENCED_OBJECT_TYPE_DATA_SYNC_STATE,
            self::REFERENCED_OBJECT_TYPE_WEB_INTERACTIVE,
            self::REFERENCED_OBJECT_TYPE_PLAYBOOK,
            self::REFERENCED_OBJECT_TYPE_FOLDER,
            self::REFERENCED_OBJECT_TYPE_PLAYBOOK_QUESTION,
            self::REFERENCED_OBJECT_TYPE_PLAYBOOK_SUBMISSION,
            self::REFERENCED_OBJECT_TYPE_PLAYBOOK_SUBMISSION_ANSWER,
            self::REFERENCED_OBJECT_TYPE_COMMERCE_PAYMENT,
            self::REFERENCED_OBJECT_TYPE_GSC_PROPERTY,
            self::REFERENCED_OBJECT_TYPE_SOX_PROTECTED_DUMMY_TYPE,
            self::REFERENCED_OBJECT_TYPE_BLOG_LISTING_PAGE,
            self::REFERENCED_OBJECT_TYPE_QUARANTINED_SUBMISSION,
            self::REFERENCED_OBJECT_TYPE_PAYMENT_SCHEDULE,
            self::REFERENCED_OBJECT_TYPE_PAYMENT_SCHEDULE_INSTALLMENT,
            self::REFERENCED_OBJECT_TYPE_MARKETING_CAMPAIGN_UTM,
            self::REFERENCED_OBJECT_TYPE_DISCOUNT_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_DISCOUNT_CODE,
            self::REFERENCED_OBJECT_TYPE_FEEDBACK_SURVEY,
            self::REFERENCED_OBJECT_TYPE_CMS_URL,
            self::REFERENCED_OBJECT_TYPE_SALES_TASK,
            self::REFERENCED_OBJECT_TYPE_SALES_WORKLOAD,
            self::REFERENCED_OBJECT_TYPE_USER,
            self::REFERENCED_OBJECT_TYPE_POSTAL_MAIL,
            self::REFERENCED_OBJECT_TYPE_SCHEMAS_BACKEND_TEST,
            self::REFERENCED_OBJECT_TYPE_PAYMENT_LINK,
            self::REFERENCED_OBJECT_TYPE_SUBMISSION_TAG,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN_STEP,
            self::REFERENCED_OBJECT_TYPE_SCHEDULING_PAGE,
            self::REFERENCED_OBJECT_TYPE_SOX_PROTECTED_TEST_TYPE,
            self::REFERENCED_OBJECT_TYPE_ORDER,
            self::REFERENCED_OBJECT_TYPE_MARKETING_SMS,
            self::REFERENCED_OBJECT_TYPE_PARTNER_ACCOUNT,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN_TEMPLATE_STEP,
            self::REFERENCED_OBJECT_TYPE_PLAYLIST,
            self::REFERENCED_OBJECT_TYPE_CLIP,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN_BUDGET_ITEM,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN_SPEND_ITEM,
            self::REFERENCED_OBJECT_TYPE_MIC,
            self::REFERENCED_OBJECT_TYPE_CONTENT_AUDIT,
            self::REFERENCED_OBJECT_TYPE_CONTENT_AUDIT_PAGE,
            self::REFERENCED_OBJECT_TYPE_PLAYLIST_FOLDER,
            self::REFERENCED_OBJECT_TYPE_LEAD,
            self::REFERENCED_OBJECT_TYPE_ABANDONED_CART,
            self::REFERENCED_OBJECT_TYPE_EXTERNAL_WEB_URL,
            self::REFERENCED_OBJECT_TYPE_VIEW,
            self::REFERENCED_OBJECT_TYPE_VIEW_BLOCK,
            self::REFERENCED_OBJECT_TYPE_ROSTER,
            self::REFERENCED_OBJECT_TYPE_CART,
            self::REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW_ACTION,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_PROFILE,
            self::REFERENCED_OBJECT_TYPE_PARTNER_CLIENT,
            self::REFERENCED_OBJECT_TYPE_ROSTER_MEMBER,
            self::REFERENCED_OBJECT_TYPE_MARKETING_EVENT_ATTENDANCE,
            self::REFERENCED_OBJECT_TYPE_ALL_PAGES,
            self::REFERENCED_OBJECT_TYPE_AI_FORECAST,
            self::REFERENCED_OBJECT_TYPE_CRM_PIPELINES_DUMMY_TYPE,
            self::REFERENCED_OBJECT_TYPE_KNOWLEDGE_ARTICLE,
            self::REFERENCED_OBJECT_TYPE_PROPERTY_INFO,
            self::REFERENCED_OBJECT_TYPE_DATA_PRIVACY_CONSENT,
            self::REFERENCED_OBJECT_TYPE_GOAL_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_SCORE_CONFIGURATION,
            self::REFERENCED_OBJECT_TYPE_AUDIENCE,
            self::REFERENCED_OBJECT_TYPE_PARTNER_CLIENT_REVENUE,
            self::REFERENCED_OBJECT_TYPE_AUTOMATION_JOURNEY,
            self::REFERENCED_OBJECT_TYPE_UNKNOWN,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_STRING,
            self::TYPE_NUMBER,
            self::TYPE_BOOL,
            self::TYPE_DATETIME,
            self::TYPE_ENUMERATION,
            self::TYPE_DATE,
            self::TYPE_PHONE_NUMBER,
            self::TYPE_CURRENCY_NUMBER,
            self::TYPE_JSON,
            self::TYPE_OBJECT_COORDINATES,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldTypeAllowableValues()
    {
        return [
            self::FIELD_TYPE_BOOLEANCHECKBOX,
            self::FIELD_TYPE_CHECKBOX,
            self::FIELD_TYPE_DATE,
            self::FIELD_TYPE_FILE,
            self::FIELD_TYPE_NUMBER,
            self::FIELD_TYPE_PHONENUMBER,
            self::FIELD_TYPE_RADIO,
            self::FIELD_TYPE_SELECT,
            self::FIELD_TYPE_TEXT,
            self::FIELD_TYPE_TEXTAREA,
            self::FIELD_TYPE_CALCULATION_EQUATION,
            self::FIELD_TYPE_CALCULATION_ROLLUP,
            self::FIELD_TYPE_CALCULATION_SCORE,
            self::FIELD_TYPE_CALCULATION_READ_TIME,
            self::FIELD_TYPE_UNKNOWN,
            self::FIELD_TYPE_HTML,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('help_text', $data ?? [], null);
        $this->setIfExists('referenced_object_type', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('options', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('external_options_reference_type', $data ?? [], null);
        $this->setIfExists('label', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('field_type', $data ?? [], null);
        $this->setIfExists('options_url', $data ?? [], null);
        $this->setIfExists('external_options', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getReferencedObjectTypeAllowableValues();
        if (!is_null($this->container['referenced_object_type']) && !in_array($this->container['referenced_object_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'referenced_object_type', must be one of '%s'",
                $this->container['referenced_object_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['options'] === null) {
            $invalidProperties[] = "'options' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!is_null($this->container['field_type']) && !in_array($this->container['field_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field_type', must be one of '%s'",
                $this->container['field_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['external_options'] === null) {
            $invalidProperties[] = "'external_options' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets help_text
     *
     * @return string|null
     */
    public function getHelpText()
    {
        return $this->container['help_text'];
    }

    /**
     * Sets help_text
     *
     * @param string|null $help_text help_text
     *
     * @return self
     */
    public function setHelpText($help_text)
    {
        if (is_null($help_text)) {
            throw new \InvalidArgumentException('non-nullable help_text cannot be null');
        }
        $this->container['help_text'] = $help_text;

        return $this;
    }

    /**
     * Gets referenced_object_type
     *
     * @return string|null
     */
    public function getReferencedObjectType()
    {
        return $this->container['referenced_object_type'];
    }

    /**
     * Sets referenced_object_type
     *
     * @param string|null $referenced_object_type referenced_object_type
     *
     * @return self
     */
    public function setReferencedObjectType($referenced_object_type)
    {
        if (is_null($referenced_object_type)) {
            throw new \InvalidArgumentException('non-nullable referenced_object_type cannot be null');
        }
        $allowedValues = $this->getReferencedObjectTypeAllowableValues();
        if (!in_array($referenced_object_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'referenced_object_type', must be one of '%s'",
                    $referenced_object_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['referenced_object_type'] = $referenced_object_type;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets options
     *
     * @return \HubSpot\Client\Automation\Actions\Model\Option[]
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param \HubSpot\Client\Automation\Actions\Model\Option[] $options options
     *
     * @return self
     */
    public function setOptions($options)
    {
        if (is_null($options)) {
            throw new \InvalidArgumentException('non-nullable options cannot be null');
        }
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets external_options_reference_type
     *
     * @return string|null
     */
    public function getExternalOptionsReferenceType()
    {
        return $this->container['external_options_reference_type'];
    }

    /**
     * Sets external_options_reference_type
     *
     * @param string|null $external_options_reference_type external_options_reference_type
     *
     * @return self
     */
    public function setExternalOptionsReferenceType($external_options_reference_type)
    {
        if (is_null($external_options_reference_type)) {
            throw new \InvalidArgumentException('non-nullable external_options_reference_type cannot be null');
        }
        $this->container['external_options_reference_type'] = $external_options_reference_type;

        return $this;
    }

    /**
     * Gets label
     *
     * @return string|null
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     *
     * @param string|null $label label
     *
     * @return self
     */
    public function setLabel($label)
    {
        if (is_null($label)) {
            throw new \InvalidArgumentException('non-nullable label cannot be null');
        }
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets field_type
     *
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->container['field_type'];
    }

    /**
     * Sets field_type
     *
     * @param string|null $field_type field_type
     *
     * @return self
     */
    public function setFieldType($field_type)
    {
        if (is_null($field_type)) {
            throw new \InvalidArgumentException('non-nullable field_type cannot be null');
        }
        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!in_array($field_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field_type', must be one of '%s'",
                    $field_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field_type'] = $field_type;

        return $this;
    }

    /**
     * Gets options_url
     *
     * @return string|null
     */
    public function getOptionsUrl()
    {
        return $this->container['options_url'];
    }

    /**
     * Sets options_url
     *
     * @param string|null $options_url options_url
     *
     * @return self
     */
    public function setOptionsUrl($options_url)
    {
        if (is_null($options_url)) {
            throw new \InvalidArgumentException('non-nullable options_url cannot be null');
        }
        $this->container['options_url'] = $options_url;

        return $this;
    }

    /**
     * Gets external_options
     *
     * @return bool
     */
    public function getExternalOptions()
    {
        return $this->container['external_options'];
    }

    /**
     * Sets external_options
     *
     * @param bool $external_options external_options
     *
     * @return self
     */
    public function setExternalOptions($external_options)
    {
        if (is_null($external_options)) {
            throw new \InvalidArgumentException('non-nullable external_options cannot be null');
        }
        $this->container['external_options'] = $external_options;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


