<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\StorageBatchOperations;

class Bucket extends \Google\Model
{
  /**
   * Required. Bucket name for the objects to be transformed.
   *
   * @var string
   */
  public $bucket;
  protected $manifestType = Manifest::class;
  protected $manifestDataType = '';
  protected $prefixListType = PrefixList::class;
  protected $prefixListDataType = '';

  /**
   * Required. Bucket name for the objects to be transformed.
   *
   * @param string $bucket
   */
  public function setBucket($bucket)
  {
    $this->bucket = $bucket;
  }
  /**
   * @return string
   */
  public function getBucket()
  {
    return $this->bucket;
  }
  /**
   * Specifies objects in a manifest file.
   *
   * @param Manifest $manifest
   */
  public function setManifest(Manifest $manifest)
  {
    $this->manifest = $manifest;
  }
  /**
   * @return Manifest
   */
  public function getManifest()
  {
    return $this->manifest;
  }
  /**
   * Specifies objects matching a prefix set.
   *
   * @param PrefixList $prefixList
   */
  public function setPrefixList(PrefixList $prefixList)
  {
    $this->prefixList = $prefixList;
  }
  /**
   * @return PrefixList
   */
  public function getPrefixList()
  {
    return $this->prefixList;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Bucket::class, 'Google_Service_StorageBatchOperations_Bucket');
