<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudIntegrationsV1alphaConnectionSchemaMetadata extends \Google\Collection
{
  protected $collection_key = 'entities';
  /**
   * List of actions.
   *
   * @var string[]
   */
  public $actions;
  /**
   * List of entity names.
   *
   * @var string[]
   */
  public $entities;

  /**
   * List of actions.
   *
   * @param string[] $actions
   */
  public function setActions($actions)
  {
    $this->actions = $actions;
  }
  /**
   * @return string[]
   */
  public function getActions()
  {
    return $this->actions;
  }
  /**
   * List of entity names.
   *
   * @param string[] $entities
   */
  public function setEntities($entities)
  {
    $this->entities = $entities;
  }
  /**
   * @return string[]
   */
  public function getEntities()
  {
    return $this->entities;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudIntegrationsV1alphaConnectionSchemaMetadata::class, 'Google_Service_Integrations_GoogleCloudIntegrationsV1alphaConnectionSchemaMetadata');
