<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class IntegrationDetails extends \Google\Model
{
  /**
   * Additional details of the entry in string format. Must be UTF-8 encoded
   * with a length of no more than 1000 characters.
   *
   * @var string
   */
  public $details;
  /**
   * An external identifier to be associated with the entry. The integration
   * code will show up together with the entry in many places in the system, for
   * example, reporting. Must be UTF-8 encoded with a length of no more than 500
   * characters.
   *
   * @var string
   */
  public $integrationCode;

  /**
   * Additional details of the entry in string format. Must be UTF-8 encoded
   * with a length of no more than 1000 characters.
   *
   * @param string $details
   */
  public function setDetails($details)
  {
    $this->details = $details;
  }
  /**
   * @return string
   */
  public function getDetails()
  {
    return $this->details;
  }
  /**
   * An external identifier to be associated with the entry. The integration
   * code will show up together with the entry in many places in the system, for
   * example, reporting. Must be UTF-8 encoded with a length of no more than 500
   * characters.
   *
   * @param string $integrationCode
   */
  public function setIntegrationCode($integrationCode)
  {
    $this->integrationCode = $integrationCode;
  }
  /**
   * @return string
   */
  public function getIntegrationCode()
  {
    return $this->integrationCode;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IntegrationDetails::class, 'Google_Service_DisplayVideo_IntegrationDetails');
