<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Directory;

class Users extends \Google\Collection
{
  protected $collection_key = 'users';
  protected $internal_gapi_mappings = [
        "triggerEvent" => "trigger_event",
  ];
  /**
   * ETag of the resource.
   *
   * @var string
   */
  public $etag;
  /**
   * Kind of resource this is.
   *
   * @var string
   */
  public $kind;
  /**
   * Token used to access next page of this result. The page token is only valid
   * for three days.
   *
   * @var string
   */
  public $nextPageToken;
  /**
   * Event that triggered this response (only used in case of Push Response)
   *
   * @var string
   */
  public $triggerEvent;
  protected $usersType = User::class;
  protected $usersDataType = 'array';

  /**
   * ETag of the resource.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Kind of resource this is.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Token used to access next page of this result. The page token is only valid
   * for three days.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Event that triggered this response (only used in case of Push Response)
   *
   * @param string $triggerEvent
   */
  public function setTriggerEvent($triggerEvent)
  {
    $this->triggerEvent = $triggerEvent;
  }
  /**
   * @return string
   */
  public function getTriggerEvent()
  {
    return $this->triggerEvent;
  }
  /**
   * A list of user objects.
   *
   * @param User[] $users
   */
  public function setUsers($users)
  {
    $this->users = $users;
  }
  /**
   * @return User[]
   */
  public function getUsers()
  {
    return $this->users;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Users::class, 'Google_Service_Directory_Users');
