<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class TestIamPermissionsRequest extends \Google\Collection
{
  protected $collection_key = 'permissions';
  /**
   * The set of permissions to check for the resource. Permissions with
   * wildcards (such as * or storage.*) are not allowed. For more information
   * see IAM Overview (https://cloud.google.com/iam/docs/overview#permissions).
   *
   * @var string[]
   */
  public $permissions;

  /**
   * The set of permissions to check for the resource. Permissions with
   * wildcards (such as * or storage.*) are not allowed. For more information
   * see IAM Overview (https://cloud.google.com/iam/docs/overview#permissions).
   *
   * @param string[] $permissions
   */
  public function setPermissions($permissions)
  {
    $this->permissions = $permissions;
  }
  /**
   * @return string[]
   */
  public function getPermissions()
  {
    return $this->permissions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TestIamPermissionsRequest::class, 'Google_Service_Dataproc_TestIamPermissionsRequest');
