<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class NodeManagement extends \Google\Model
{
  /**
   * A flag that specifies whether the node auto-repair is enabled for the node
   * pool. If enabled, the nodes in this node pool will be monitored and, if
   * they fail health checks too many times, an automatic repair action will be
   * triggered.
   *
   * @var bool
   */
  public $autoRepair;
  /**
   * A flag that specifies whether node auto-upgrade is enabled for the node
   * pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
   * up to date with the latest release version of Kubernetes.
   *
   * @var bool
   */
  public $autoUpgrade;
  protected $upgradeOptionsType = AutoUpgradeOptions::class;
  protected $upgradeOptionsDataType = '';

  /**
   * A flag that specifies whether the node auto-repair is enabled for the node
   * pool. If enabled, the nodes in this node pool will be monitored and, if
   * they fail health checks too many times, an automatic repair action will be
   * triggered.
   *
   * @param bool $autoRepair
   */
  public function setAutoRepair($autoRepair)
  {
    $this->autoRepair = $autoRepair;
  }
  /**
   * @return bool
   */
  public function getAutoRepair()
  {
    return $this->autoRepair;
  }
  /**
   * A flag that specifies whether node auto-upgrade is enabled for the node
   * pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
   * up to date with the latest release version of Kubernetes.
   *
   * @param bool $autoUpgrade
   */
  public function setAutoUpgrade($autoUpgrade)
  {
    $this->autoUpgrade = $autoUpgrade;
  }
  /**
   * @return bool
   */
  public function getAutoUpgrade()
  {
    return $this->autoUpgrade;
  }
  /**
   * Specifies the Auto Upgrade knobs for the node pool.
   *
   * @param AutoUpgradeOptions $upgradeOptions
   */
  public function setUpgradeOptions(AutoUpgradeOptions $upgradeOptions)
  {
    $this->upgradeOptions = $upgradeOptions;
  }
  /**
   * @return AutoUpgradeOptions
   */
  public function getUpgradeOptions()
  {
    return $this->upgradeOptions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NodeManagement::class, 'Google_Service_Container_NodeManagement');
