<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ErrorInfo extends \Google\Model
{
  /**
   * The logical grouping to which the "reason" belongs. The error domain is
   * typically the registered service name of the tool or product that generates
   * the error. Example: "pubsub.googleapis.com". If the error is generated by
   * some common infrastructure, the error domain must be a globally unique
   * value that identifies the infrastructure. For Google API infrastructure,
   * the error domain is "googleapis.com".
   *
   * @var string
   */
  public $domain;
  /**
   * Additional structured details about this error.
   *
   * Keys must match a regular expression of `a-z+` but should ideally be
   * lowerCamelCase. Also, they must be limited to 64 characters in length. When
   * identifying the current value of an exceeded limit, the units should be
   * contained in the key, not the value.  For example, rather than
   * `{"instanceLimit": "100/request"}`, should be returned as,
   * `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
   * instances that can be created in a single (batch) request.
   *
   * @var string[]
   */
  public $metadatas;
  /**
   * The reason of the error. This is a constant value that identifies the
   * proximate cause of the error. Error reasons are unique within a particular
   * domain of errors. This should be at most 63 characters and match a regular
   * expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
   *
   * @var string
   */
  public $reason;

  /**
   * The logical grouping to which the "reason" belongs. The error domain is
   * typically the registered service name of the tool or product that generates
   * the error. Example: "pubsub.googleapis.com". If the error is generated by
   * some common infrastructure, the error domain must be a globally unique
   * value that identifies the infrastructure. For Google API infrastructure,
   * the error domain is "googleapis.com".
   *
   * @param string $domain
   */
  public function setDomain($domain)
  {
    $this->domain = $domain;
  }
  /**
   * @return string
   */
  public function getDomain()
  {
    return $this->domain;
  }
  /**
   * Additional structured details about this error.
   *
   * Keys must match a regular expression of `a-z+` but should ideally be
   * lowerCamelCase. Also, they must be limited to 64 characters in length. When
   * identifying the current value of an exceeded limit, the units should be
   * contained in the key, not the value.  For example, rather than
   * `{"instanceLimit": "100/request"}`, should be returned as,
   * `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
   * instances that can be created in a single (batch) request.
   *
   * @param string[] $metadatas
   */
  public function setMetadatas($metadatas)
  {
    $this->metadatas = $metadatas;
  }
  /**
   * @return string[]
   */
  public function getMetadatas()
  {
    return $this->metadatas;
  }
  /**
   * The reason of the error. This is a constant value that identifies the
   * proximate cause of the error. Error reasons are unique within a particular
   * domain of errors. This should be at most 63 characters and match a regular
   * expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
   *
   * @param string $reason
   */
  public function setReason($reason)
  {
    $this->reason = $reason;
  }
  /**
   * @return string
   */
  public function getReason()
  {
    return $this->reason;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ErrorInfo::class, 'Google_Service_Compute_ErrorInfo');
