<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTalentSolution;

class Company extends \Google\Collection
{
  /**
   * Default value if the size isn't specified.
   */
  public const SIZE_COMPANY_SIZE_UNSPECIFIED = 'COMPANY_SIZE_UNSPECIFIED';
  /**
   * The company has less than 50 employees.
   */
  public const SIZE_MINI = 'MINI';
  /**
   * The company has between 50 and 99 employees.
   */
  public const SIZE_SMALL = 'SMALL';
  /**
   * The company has between 100 and 499 employees.
   */
  public const SIZE_SMEDIUM = 'SMEDIUM';
  /**
   * The company has between 500 and 999 employees.
   */
  public const SIZE_MEDIUM = 'MEDIUM';
  /**
   * The company has between 1,000 and 4,999 employees.
   */
  public const SIZE_BIG = 'BIG';
  /**
   * The company has between 5,000 and 9,999 employees.
   */
  public const SIZE_BIGGER = 'BIGGER';
  /**
   * The company has 10,000 or more employees.
   */
  public const SIZE_GIANT = 'GIANT';
  protected $collection_key = 'keywordSearchableJobCustomAttributes';
  /**
   * The URI to employer's career site or careers page on the employer's web
   * site, for example, "https://careers.google.com".
   *
   * @var string
   */
  public $careerSiteUri;
  protected $derivedInfoType = CompanyDerivedInfo::class;
  protected $derivedInfoDataType = '';
  /**
   * Required. The display name of the company, for example, "Google LLC".
   *
   * @var string
   */
  public $displayName;
  /**
   * Equal Employment Opportunity legal disclaimer text to be associated with
   * all jobs, and typically to be displayed in all roles. The maximum number of
   * allowed characters is 500.
   *
   * @var string
   */
  public $eeoText;
  /**
   * Required. Client side company identifier, used to uniquely identify the
   * company. The maximum number of allowed characters is 255.
   *
   * @var string
   */
  public $externalId;
  /**
   * The street address of the company's main headquarters, which may be
   * different from the job location. The service attempts to geolocate the
   * provided address, and populates a more specific location wherever possible
   * in DerivedInfo.headquarters_location.
   *
   * @var string
   */
  public $headquartersAddress;
  /**
   * Set to true if it is the hiring agency that post jobs for other employers.
   * Defaults to false if not provided.
   *
   * @var bool
   */
  public $hiringAgency;
  /**
   * A URI that hosts the employer's company logo.
   *
   * @var string
   */
  public $imageUri;
  /**
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the Job.custom_attributes going forward. A list of keys of
   * filterable Job.custom_attributes, whose corresponding `string_values` are
   * used in keyword searches. Jobs with `string_values` under these specified
   * field keys are returned if any of the values match the search keyword.
   * Custom field values with parenthesis, brackets and special symbols are not
   * searchable as-is, and those keyword queries must be surrounded by quotes.
   *
   * @deprecated
   * @var string[]
   */
  public $keywordSearchableJobCustomAttributes;
  /**
   * Required during company update. The resource name for a company. This is
   * generated by the service when a company is created. The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * @var string
   */
  public $name;
  /**
   * The employer's company size.
   *
   * @var string
   */
  public $size;
  /**
   * Output only. Indicates whether a company is flagged to be suspended from
   * public availability by the service when job content appears suspicious,
   * abusive, or spammy.
   *
   * @var bool
   */
  public $suspended;
  /**
   * The URI representing the company's primary web site or home page, for
   * example, "https://www.google.com". The maximum number of allowed characters
   * is 255.
   *
   * @var string
   */
  public $websiteUri;

  /**
   * The URI to employer's career site or careers page on the employer's web
   * site, for example, "https://careers.google.com".
   *
   * @param string $careerSiteUri
   */
  public function setCareerSiteUri($careerSiteUri)
  {
    $this->careerSiteUri = $careerSiteUri;
  }
  /**
   * @return string
   */
  public function getCareerSiteUri()
  {
    return $this->careerSiteUri;
  }
  /**
   * Output only. Derived details about the company.
   *
   * @param CompanyDerivedInfo $derivedInfo
   */
  public function setDerivedInfo(CompanyDerivedInfo $derivedInfo)
  {
    $this->derivedInfo = $derivedInfo;
  }
  /**
   * @return CompanyDerivedInfo
   */
  public function getDerivedInfo()
  {
    return $this->derivedInfo;
  }
  /**
   * Required. The display name of the company, for example, "Google LLC".
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Equal Employment Opportunity legal disclaimer text to be associated with
   * all jobs, and typically to be displayed in all roles. The maximum number of
   * allowed characters is 500.
   *
   * @param string $eeoText
   */
  public function setEeoText($eeoText)
  {
    $this->eeoText = $eeoText;
  }
  /**
   * @return string
   */
  public function getEeoText()
  {
    return $this->eeoText;
  }
  /**
   * Required. Client side company identifier, used to uniquely identify the
   * company. The maximum number of allowed characters is 255.
   *
   * @param string $externalId
   */
  public function setExternalId($externalId)
  {
    $this->externalId = $externalId;
  }
  /**
   * @return string
   */
  public function getExternalId()
  {
    return $this->externalId;
  }
  /**
   * The street address of the company's main headquarters, which may be
   * different from the job location. The service attempts to geolocate the
   * provided address, and populates a more specific location wherever possible
   * in DerivedInfo.headquarters_location.
   *
   * @param string $headquartersAddress
   */
  public function setHeadquartersAddress($headquartersAddress)
  {
    $this->headquartersAddress = $headquartersAddress;
  }
  /**
   * @return string
   */
  public function getHeadquartersAddress()
  {
    return $this->headquartersAddress;
  }
  /**
   * Set to true if it is the hiring agency that post jobs for other employers.
   * Defaults to false if not provided.
   *
   * @param bool $hiringAgency
   */
  public function setHiringAgency($hiringAgency)
  {
    $this->hiringAgency = $hiringAgency;
  }
  /**
   * @return bool
   */
  public function getHiringAgency()
  {
    return $this->hiringAgency;
  }
  /**
   * A URI that hosts the employer's company logo.
   *
   * @param string $imageUri
   */
  public function setImageUri($imageUri)
  {
    $this->imageUri = $imageUri;
  }
  /**
   * @return string
   */
  public function getImageUri()
  {
    return $this->imageUri;
  }
  /**
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the Job.custom_attributes going forward. A list of keys of
   * filterable Job.custom_attributes, whose corresponding `string_values` are
   * used in keyword searches. Jobs with `string_values` under these specified
   * field keys are returned if any of the values match the search keyword.
   * Custom field values with parenthesis, brackets and special symbols are not
   * searchable as-is, and those keyword queries must be surrounded by quotes.
   *
   * @deprecated
   * @param string[] $keywordSearchableJobCustomAttributes
   */
  public function setKeywordSearchableJobCustomAttributes($keywordSearchableJobCustomAttributes)
  {
    $this->keywordSearchableJobCustomAttributes = $keywordSearchableJobCustomAttributes;
  }
  /**
   * @deprecated
   * @return string[]
   */
  public function getKeywordSearchableJobCustomAttributes()
  {
    return $this->keywordSearchableJobCustomAttributes;
  }
  /**
   * Required during company update. The resource name for a company. This is
   * generated by the service when a company is created. The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The employer's company size.
   *
   * Accepted values: COMPANY_SIZE_UNSPECIFIED, MINI, SMALL, SMEDIUM, MEDIUM,
   * BIG, BIGGER, GIANT
   *
   * @param self::SIZE_* $size
   */
  public function setSize($size)
  {
    $this->size = $size;
  }
  /**
   * @return self::SIZE_*
   */
  public function getSize()
  {
    return $this->size;
  }
  /**
   * Output only. Indicates whether a company is flagged to be suspended from
   * public availability by the service when job content appears suspicious,
   * abusive, or spammy.
   *
   * @param bool $suspended
   */
  public function setSuspended($suspended)
  {
    $this->suspended = $suspended;
  }
  /**
   * @return bool
   */
  public function getSuspended()
  {
    return $this->suspended;
  }
  /**
   * The URI representing the company's primary web site or home page, for
   * example, "https://www.google.com". The maximum number of allowed characters
   * is 255.
   *
   * @param string $websiteUri
   */
  public function setWebsiteUri($websiteUri)
  {
    $this->websiteUri = $websiteUri;
  }
  /**
   * @return string
   */
  public function getWebsiteUri()
  {
    return $this->websiteUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Company::class, 'Google_Service_CloudTalentSolution_Company');
