<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudMachineLearningEngine;

class GoogleCloudMlV1HyperparameterOutputHyperparameterMetric extends \Google\Model
{
  /**
   * The objective value at this training step.
   *
   * @var 
   */
  public $objectiveValue;
  /**
   * The global training step for this metric.
   *
   * @var string
   */
  public $trainingStep;

  public function setObjectiveValue($objectiveValue)
  {
    $this->objectiveValue = $objectiveValue;
  }
  public function getObjectiveValue()
  {
    return $this->objectiveValue;
  }
  /**
   * The global training step for this metric.
   *
   * @param string $trainingStep
   */
  public function setTrainingStep($trainingStep)
  {
    $this->trainingStep = $trainingStep;
  }
  /**
   * @return string
   */
  public function getTrainingStep()
  {
    return $this->trainingStep;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudMlV1HyperparameterOutputHyperparameterMetric::class, 'Google_Service_CloudMachineLearningEngine_GoogleCloudMlV1HyperparameterOutputHyperparameterMetric');
