<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation extends \Google\Model
{
  /**
   * Output only. The time when environment was attached to the security
   * profile.
   *
   * @var string
   */
  public $attachTime;
  /**
   * Immutable. Name of the environment that the profile is attached to.
   *
   * @var string
   */
  public $name;
  /**
   * DEPRECATED: DO NOT USE Revision ID of the security profile.
   *
   * @deprecated
   * @var string
   */
  public $securityProfileRevisionId;

  /**
   * Output only. The time when environment was attached to the security
   * profile.
   *
   * @param string $attachTime
   */
  public function setAttachTime($attachTime)
  {
    $this->attachTime = $attachTime;
  }
  /**
   * @return string
   */
  public function getAttachTime()
  {
    return $this->attachTime;
  }
  /**
   * Immutable. Name of the environment that the profile is attached to.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * DEPRECATED: DO NOT USE Revision ID of the security profile.
   *
   * @deprecated
   * @param string $securityProfileRevisionId
   */
  public function setSecurityProfileRevisionId($securityProfileRevisionId)
  {
    $this->securityProfileRevisionId = $securityProfileRevisionId;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getSecurityProfileRevisionId()
  {
    return $this->securityProfileRevisionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation::class, 'Google_Service_Apigee_GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation');
