<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class SubscriptionPurchasesAcknowledgeRequest extends \Google\Model
{
  /**
   * Payload to attach to the purchase.
   *
   * @var string
   */
  public $developerPayload;
  protected $externalAccountIdsType = ExternalAccountIds::class;
  protected $externalAccountIdsDataType = '';

  /**
   * Payload to attach to the purchase.
   *
   * @param string $developerPayload
   */
  public function setDeveloperPayload($developerPayload)
  {
    $this->developerPayload = $developerPayload;
  }
  /**
   * @return string
   */
  public function getDeveloperPayload()
  {
    return $this->developerPayload;
  }
  /**
   * Optional. User account identifier in your app.
   *
   * @param ExternalAccountIds $externalAccountIds
   */
  public function setExternalAccountIds(ExternalAccountIds $externalAccountIds)
  {
    $this->externalAccountIds = $externalAccountIds;
  }
  /**
   * @return ExternalAccountIds
   */
  public function getExternalAccountIds()
  {
    return $this->externalAccountIds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SubscriptionPurchasesAcknowledgeRequest::class, 'Google_Service_AndroidPublisher_SubscriptionPurchasesAcknowledgeRequest');
